
-- --------------------------------------------------
-- Entity Designer DDL Script for SQL Server 2005, 2008, and Azure
-- --------------------------------------------------
-- Date Created: 08/25/2013 22:24:36
-- Generated from EDMX file: C:\Users\Jakub Gruszecki\Documents\Visual Studio 2012\Projects\imkp.paip.pl\SourceCode\Centuria.Imkp.Game.Web\Models\Game.edmx
-- --------------------------------------------------

SET QUOTED_IDENTIFIER OFF;
GO
USE [staging.game.imkp.paip.pl];
GO
IF SCHEMA_ID(N'dbo') IS NULL EXECUTE(N'CREATE SCHEMA [dbo]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------

IF OBJECT_ID(N'[dbo].[FK_CompanyWorld]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[CompanySet] DROP CONSTRAINT [FK_CompanyWorld];
GO
IF OBJECT_ID(N'[dbo].[FK_PlayerCompany]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[PlayerSet] DROP CONSTRAINT [FK_PlayerCompany];
GO
IF OBJECT_ID(N'[dbo].[FK_PlayerWorld]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[PlayerSet] DROP CONSTRAINT [FK_PlayerWorld];
GO
IF OBJECT_ID(N'[dbo].[FK_CompanyProductionProcess]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ProductionProcessSet] DROP CONSTRAINT [FK_CompanyProductionProcess];
GO
IF OBJECT_ID(N'[dbo].[FK_ExternalFactorWorld]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ExternalFactorSet] DROP CONSTRAINT [FK_ExternalFactorWorld];
GO
IF OBJECT_ID(N'[dbo].[FK_NewspaperCompany]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[NewspaperSet] DROP CONSTRAINT [FK_NewspaperCompany];
GO
IF OBJECT_ID(N'[dbo].[FK_NewspaperExternalFactor_Newspaper]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[NewspaperExternalFactor] DROP CONSTRAINT [FK_NewspaperExternalFactor_Newspaper];
GO
IF OBJECT_ID(N'[dbo].[FK_NewspaperExternalFactor_ExternalFactor]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[NewspaperExternalFactor] DROP CONSTRAINT [FK_NewspaperExternalFactor_ExternalFactor];
GO
IF OBJECT_ID(N'[dbo].[FK_ProductionProcessInventoryItem]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ProductionProcessSet] DROP CONSTRAINT [FK_ProductionProcessInventoryItem];
GO
IF OBJECT_ID(N'[dbo].[FK_CompanyDistributionProcess]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[DistributionProcessSet] DROP CONSTRAINT [FK_CompanyDistributionProcess];
GO
IF OBJECT_ID(N'[dbo].[FK_DistributionProcessCargoItem]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[CargoItemSet] DROP CONSTRAINT [FK_DistributionProcessCargoItem];
GO
IF OBJECT_ID(N'[dbo].[FK_CargoItemProductionProcess]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[CargoItemSet] DROP CONSTRAINT [FK_CargoItemProductionProcess];
GO
IF OBJECT_ID(N'[dbo].[FK_DistributionProcessSale]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[SaleSet] DROP CONSTRAINT [FK_DistributionProcessSale];
GO
IF OBJECT_ID(N'[dbo].[FK_TaskAssignmentPlayer]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[TaskAssignmentSet] DROP CONSTRAINT [FK_TaskAssignmentPlayer];
GO
IF OBJECT_ID(N'[dbo].[FK_PlayerAnswerMultipleMatchPlayerAnswer]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[MultipleMatchPlayerAnswerSet] DROP CONSTRAINT [FK_PlayerAnswerMultipleMatchPlayerAnswer];
GO
IF OBJECT_ID(N'[dbo].[FK_TaskAssignmentPlayerAnswer]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[PlayerAnswerSet] DROP CONSTRAINT [FK_TaskAssignmentPlayerAnswer];
GO
IF OBJECT_ID(N'[dbo].[FK_TaskAssignmentTaskPhaseStatus]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[TaskPhaseStatusSet] DROP CONSTRAINT [FK_TaskAssignmentTaskPhaseStatus];
GO
IF OBJECT_ID(N'[dbo].[FK_TaskAssignmentDialogActivation]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[DialogActivationSet] DROP CONSTRAINT [FK_TaskAssignmentDialogActivation];
GO
IF OBJECT_ID(N'[dbo].[FK_PlayerAnswerSingleChoicePlayerAnswer]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[SingleChoicePlayerAnswerSet] DROP CONSTRAINT [FK_PlayerAnswerSingleChoicePlayerAnswer];
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------

IF OBJECT_ID(N'[dbo].[CompanySet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CompanySet];
GO
IF OBJECT_ID(N'[dbo].[PlayerSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[PlayerSet];
GO
IF OBJECT_ID(N'[dbo].[WorldSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[WorldSet];
GO
IF OBJECT_ID(N'[dbo].[ProductionProcessSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProductionProcessSet];
GO
IF OBJECT_ID(N'[dbo].[ExternalFactorSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ExternalFactorSet];
GO
IF OBJECT_ID(N'[dbo].[NewspaperSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[NewspaperSet];
GO
IF OBJECT_ID(N'[dbo].[InventoryItemSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[InventoryItemSet];
GO
IF OBJECT_ID(N'[dbo].[DistributionProcessSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[DistributionProcessSet];
GO
IF OBJECT_ID(N'[dbo].[CargoItemSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CargoItemSet];
GO
IF OBJECT_ID(N'[dbo].[SaleSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[SaleSet];
GO
IF OBJECT_ID(N'[dbo].[TaskAssignmentSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[TaskAssignmentSet];
GO
IF OBJECT_ID(N'[dbo].[PlayerAnswerSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[PlayerAnswerSet];
GO
IF OBJECT_ID(N'[dbo].[MultipleMatchPlayerAnswerSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MultipleMatchPlayerAnswerSet];
GO
IF OBJECT_ID(N'[dbo].[SingleChoicePlayerAnswerSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[SingleChoicePlayerAnswerSet];
GO
IF OBJECT_ID(N'[dbo].[DialogActivationSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[DialogActivationSet];
GO
IF OBJECT_ID(N'[dbo].[TaskPhaseStatusSet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[TaskPhaseStatusSet];
GO
IF OBJECT_ID(N'[dbo].[NewspaperExternalFactor]', 'U') IS NOT NULL
    DROP TABLE [dbo].[NewspaperExternalFactor];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'CompanySet'
CREATE TABLE [dbo].[CompanySet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [WorldId] int  NOT NULL,
    [Balance] decimal(19,4)  NOT NULL
);
GO

-- Creating table 'PlayerSet'
CREATE TABLE [dbo].[PlayerSet] (
    [UserId] uniqueidentifier  NOT NULL,
    [WorldId] int  NOT NULL,
    [CompanyId] int  NULL,
    [Name] nvarchar(max)  NOT NULL,
    [Surname] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'WorldSet'
CREATE TABLE [dbo].[WorldSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [CreationDate] datetime  NOT NULL,
    [Name] nvarchar(50)  NOT NULL,
    [StateCode] int  NOT NULL,
    [OwnerId] uniqueidentifier  NOT NULL,
    [RegistrationKey] nvarchar(max)  NOT NULL,
    [ActiveModuleId] int  NOT NULL
);
GO

-- Creating table 'ProductionProcessSet'
CREATE TABLE [dbo].[ProductionProcessSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [StartDate] datetime  NOT NULL,
    [Plan_EmployeesCount] int  NOT NULL,
    [Plan_ProductsCount] int  NOT NULL,
    [Plan_WorkerCost] decimal(18,2)  NOT NULL,
    [Plan_WorkerProductivity] float  NOT NULL,
    [Plan_ProductDescription] nvarchar(max)  NOT NULL,
    [CompanyId] int  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [InventoryItemId] int  NULL
);
GO

-- Creating table 'ExternalFactorSet'
CREATE TABLE [dbo].[ExternalFactorSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [WorldId] int  NOT NULL,
    [AreaType] nvarchar(max)  NOT NULL,
    [StartDate] datetime  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [Type_Description] nvarchar(max)  NOT NULL,
    [Type_Impact] int  NOT NULL
);
GO

-- Creating table 'NewspaperSet'
CREATE TABLE [dbo].[NewspaperSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [CompanyId] int  NOT NULL,
    [Price] decimal(18,2)  NOT NULL,
    [PurchaseDate] datetime  NOT NULL
);
GO

-- Creating table 'InventoryItemSet'
CREATE TABLE [dbo].[InventoryItemSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ProductsCount] int  NOT NULL
);
GO

-- Creating table 'DistributionProcessSet'
CREATE TABLE [dbo].[DistributionProcessSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [StartDate] datetime  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [CompanyId] int  NOT NULL,
    [Plan_TrucksCount] int  NOT NULL,
    [Plan_TruckCost] decimal(18,2)  NOT NULL,
    [Plan_TruckCapacity] int  NOT NULL,
    [Plan_MarketingCost] decimal(18,2)  NOT NULL,
    [Plan_AreaType] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'CargoItemSet'
CREATE TABLE [dbo].[CargoItemSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ProductsCount] int  NOT NULL,
    [DistributionProcessId] int  NOT NULL,
    [ProductionProcessId] int  NOT NULL
);
GO

-- Creating table 'SaleSet'
CREATE TABLE [dbo].[SaleSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Date] datetime  NOT NULL,
    [DistributionProcessId] int  NOT NULL,
    [Income] decimal(18,2)  NOT NULL
);
GO

-- Creating table 'TaskAssignmentSet'
CREATE TABLE [dbo].[TaskAssignmentSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [TaskId] int  NOT NULL,
    [PlayerUserId] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'PlayerAnswerSet'
CREATE TABLE [dbo].[PlayerAnswerSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Points] int  NOT NULL,
    [BonusPointsForTime] int  NOT NULL,
    [EndTime] datetime  NOT NULL,
    [TimeSpent] time  NOT NULL,
    [QuestionId] int  NOT NULL,
    [TaskAssignmentId] int  NOT NULL
);
GO

-- Creating table 'MultipleMatchPlayerAnswerSet'
CREATE TABLE [dbo].[MultipleMatchPlayerAnswerSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Definition] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NOT NULL,
    [PlayerAnswerId] int  NOT NULL
);
GO

-- Creating table 'SingleChoicePlayerAnswerSet'
CREATE TABLE [dbo].[SingleChoicePlayerAnswerSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [PlayerAnswerId] int  NOT NULL,
    [VariantId] int  NOT NULL
);
GO

-- Creating table 'DialogActivationSet'
CREATE TABLE [dbo].[DialogActivationSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [DialogId] int  NOT NULL,
    [TaskAssignmentId] int  NOT NULL
);
GO

-- Creating table 'TaskPhaseStatusSet'
CREATE TABLE [dbo].[TaskPhaseStatusSet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [TaskPhaseId] int  NOT NULL,
    [Marker] int  NOT NULL,
    [TaskAssignmentId] int  NOT NULL
);
GO

-- Creating table 'NewspaperExternalFactor'
CREATE TABLE [dbo].[NewspaperExternalFactor] (
    [NewspaperExternalFactor_ExternalFactor_Id] int  NOT NULL,
    [ExternalFactors_Id] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'CompanySet'
ALTER TABLE [dbo].[CompanySet]
ADD CONSTRAINT [PK_CompanySet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [UserId] in table 'PlayerSet'
ALTER TABLE [dbo].[PlayerSet]
ADD CONSTRAINT [PK_PlayerSet]
    PRIMARY KEY CLUSTERED ([UserId] ASC);
GO

-- Creating primary key on [Id] in table 'WorldSet'
ALTER TABLE [dbo].[WorldSet]
ADD CONSTRAINT [PK_WorldSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ProductionProcessSet'
ALTER TABLE [dbo].[ProductionProcessSet]
ADD CONSTRAINT [PK_ProductionProcessSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ExternalFactorSet'
ALTER TABLE [dbo].[ExternalFactorSet]
ADD CONSTRAINT [PK_ExternalFactorSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'NewspaperSet'
ALTER TABLE [dbo].[NewspaperSet]
ADD CONSTRAINT [PK_NewspaperSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'InventoryItemSet'
ALTER TABLE [dbo].[InventoryItemSet]
ADD CONSTRAINT [PK_InventoryItemSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'DistributionProcessSet'
ALTER TABLE [dbo].[DistributionProcessSet]
ADD CONSTRAINT [PK_DistributionProcessSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'CargoItemSet'
ALTER TABLE [dbo].[CargoItemSet]
ADD CONSTRAINT [PK_CargoItemSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SaleSet'
ALTER TABLE [dbo].[SaleSet]
ADD CONSTRAINT [PK_SaleSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'TaskAssignmentSet'
ALTER TABLE [dbo].[TaskAssignmentSet]
ADD CONSTRAINT [PK_TaskAssignmentSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'PlayerAnswerSet'
ALTER TABLE [dbo].[PlayerAnswerSet]
ADD CONSTRAINT [PK_PlayerAnswerSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'MultipleMatchPlayerAnswerSet'
ALTER TABLE [dbo].[MultipleMatchPlayerAnswerSet]
ADD CONSTRAINT [PK_MultipleMatchPlayerAnswerSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SingleChoicePlayerAnswerSet'
ALTER TABLE [dbo].[SingleChoicePlayerAnswerSet]
ADD CONSTRAINT [PK_SingleChoicePlayerAnswerSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'DialogActivationSet'
ALTER TABLE [dbo].[DialogActivationSet]
ADD CONSTRAINT [PK_DialogActivationSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'TaskPhaseStatusSet'
ALTER TABLE [dbo].[TaskPhaseStatusSet]
ADD CONSTRAINT [PK_TaskPhaseStatusSet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [NewspaperExternalFactor_ExternalFactor_Id], [ExternalFactors_Id] in table 'NewspaperExternalFactor'
ALTER TABLE [dbo].[NewspaperExternalFactor]
ADD CONSTRAINT [PK_NewspaperExternalFactor]
    PRIMARY KEY NONCLUSTERED ([NewspaperExternalFactor_ExternalFactor_Id], [ExternalFactors_Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [WorldId] in table 'CompanySet'
ALTER TABLE [dbo].[CompanySet]
ADD CONSTRAINT [FK_CompanyWorld]
    FOREIGN KEY ([WorldId])
    REFERENCES [dbo].[WorldSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CompanyWorld'
CREATE INDEX [IX_FK_CompanyWorld]
ON [dbo].[CompanySet]
    ([WorldId]);
GO

-- Creating foreign key on [CompanyId] in table 'PlayerSet'
ALTER TABLE [dbo].[PlayerSet]
ADD CONSTRAINT [FK_PlayerCompany]
    FOREIGN KEY ([CompanyId])
    REFERENCES [dbo].[CompanySet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PlayerCompany'
CREATE INDEX [IX_FK_PlayerCompany]
ON [dbo].[PlayerSet]
    ([CompanyId]);
GO

-- Creating foreign key on [WorldId] in table 'PlayerSet'
ALTER TABLE [dbo].[PlayerSet]
ADD CONSTRAINT [FK_PlayerWorld]
    FOREIGN KEY ([WorldId])
    REFERENCES [dbo].[WorldSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PlayerWorld'
CREATE INDEX [IX_FK_PlayerWorld]
ON [dbo].[PlayerSet]
    ([WorldId]);
GO

-- Creating foreign key on [CompanyId] in table 'ProductionProcessSet'
ALTER TABLE [dbo].[ProductionProcessSet]
ADD CONSTRAINT [FK_CompanyProductionProcess]
    FOREIGN KEY ([CompanyId])
    REFERENCES [dbo].[CompanySet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CompanyProductionProcess'
CREATE INDEX [IX_FK_CompanyProductionProcess]
ON [dbo].[ProductionProcessSet]
    ([CompanyId]);
GO

-- Creating foreign key on [WorldId] in table 'ExternalFactorSet'
ALTER TABLE [dbo].[ExternalFactorSet]
ADD CONSTRAINT [FK_ExternalFactorWorld]
    FOREIGN KEY ([WorldId])
    REFERENCES [dbo].[WorldSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ExternalFactorWorld'
CREATE INDEX [IX_FK_ExternalFactorWorld]
ON [dbo].[ExternalFactorSet]
    ([WorldId]);
GO

-- Creating foreign key on [CompanyId] in table 'NewspaperSet'
ALTER TABLE [dbo].[NewspaperSet]
ADD CONSTRAINT [FK_NewspaperCompany]
    FOREIGN KEY ([CompanyId])
    REFERENCES [dbo].[CompanySet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_NewspaperCompany'
CREATE INDEX [IX_FK_NewspaperCompany]
ON [dbo].[NewspaperSet]
    ([CompanyId]);
GO

-- Creating foreign key on [NewspaperExternalFactor_ExternalFactor_Id] in table 'NewspaperExternalFactor'
ALTER TABLE [dbo].[NewspaperExternalFactor]
ADD CONSTRAINT [FK_NewspaperExternalFactor_Newspaper]
    FOREIGN KEY ([NewspaperExternalFactor_ExternalFactor_Id])
    REFERENCES [dbo].[NewspaperSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [ExternalFactors_Id] in table 'NewspaperExternalFactor'
ALTER TABLE [dbo].[NewspaperExternalFactor]
ADD CONSTRAINT [FK_NewspaperExternalFactor_ExternalFactor]
    FOREIGN KEY ([ExternalFactors_Id])
    REFERENCES [dbo].[ExternalFactorSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_NewspaperExternalFactor_ExternalFactor'
CREATE INDEX [IX_FK_NewspaperExternalFactor_ExternalFactor]
ON [dbo].[NewspaperExternalFactor]
    ([ExternalFactors_Id]);
GO

-- Creating foreign key on [InventoryItemId] in table 'ProductionProcessSet'
ALTER TABLE [dbo].[ProductionProcessSet]
ADD CONSTRAINT [FK_ProductionProcessInventoryItem]
    FOREIGN KEY ([InventoryItemId])
    REFERENCES [dbo].[InventoryItemSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ProductionProcessInventoryItem'
CREATE INDEX [IX_FK_ProductionProcessInventoryItem]
ON [dbo].[ProductionProcessSet]
    ([InventoryItemId]);
GO

-- Creating foreign key on [CompanyId] in table 'DistributionProcessSet'
ALTER TABLE [dbo].[DistributionProcessSet]
ADD CONSTRAINT [FK_CompanyDistributionProcess]
    FOREIGN KEY ([CompanyId])
    REFERENCES [dbo].[CompanySet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CompanyDistributionProcess'
CREATE INDEX [IX_FK_CompanyDistributionProcess]
ON [dbo].[DistributionProcessSet]
    ([CompanyId]);
GO

-- Creating foreign key on [DistributionProcessId] in table 'CargoItemSet'
ALTER TABLE [dbo].[CargoItemSet]
ADD CONSTRAINT [FK_DistributionProcessCargoItem]
    FOREIGN KEY ([DistributionProcessId])
    REFERENCES [dbo].[DistributionProcessSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_DistributionProcessCargoItem'
CREATE INDEX [IX_FK_DistributionProcessCargoItem]
ON [dbo].[CargoItemSet]
    ([DistributionProcessId]);
GO

-- Creating foreign key on [ProductionProcessId] in table 'CargoItemSet'
ALTER TABLE [dbo].[CargoItemSet]
ADD CONSTRAINT [FK_CargoItemProductionProcess]
    FOREIGN KEY ([ProductionProcessId])
    REFERENCES [dbo].[ProductionProcessSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CargoItemProductionProcess'
CREATE INDEX [IX_FK_CargoItemProductionProcess]
ON [dbo].[CargoItemSet]
    ([ProductionProcessId]);
GO

-- Creating foreign key on [DistributionProcessId] in table 'SaleSet'
ALTER TABLE [dbo].[SaleSet]
ADD CONSTRAINT [FK_DistributionProcessSale]
    FOREIGN KEY ([DistributionProcessId])
    REFERENCES [dbo].[DistributionProcessSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_DistributionProcessSale'
CREATE INDEX [IX_FK_DistributionProcessSale]
ON [dbo].[SaleSet]
    ([DistributionProcessId]);
GO

-- Creating foreign key on [PlayerUserId] in table 'TaskAssignmentSet'
ALTER TABLE [dbo].[TaskAssignmentSet]
ADD CONSTRAINT [FK_TaskAssignmentPlayer]
    FOREIGN KEY ([PlayerUserId])
    REFERENCES [dbo].[PlayerSet]
        ([UserId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TaskAssignmentPlayer'
CREATE INDEX [IX_FK_TaskAssignmentPlayer]
ON [dbo].[TaskAssignmentSet]
    ([PlayerUserId]);
GO

-- Creating foreign key on [PlayerAnswerId] in table 'MultipleMatchPlayerAnswerSet'
ALTER TABLE [dbo].[MultipleMatchPlayerAnswerSet]
ADD CONSTRAINT [FK_PlayerAnswerMultipleMatchPlayerAnswer]
    FOREIGN KEY ([PlayerAnswerId])
    REFERENCES [dbo].[PlayerAnswerSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PlayerAnswerMultipleMatchPlayerAnswer'
CREATE INDEX [IX_FK_PlayerAnswerMultipleMatchPlayerAnswer]
ON [dbo].[MultipleMatchPlayerAnswerSet]
    ([PlayerAnswerId]);
GO

-- Creating foreign key on [TaskAssignmentId] in table 'PlayerAnswerSet'
ALTER TABLE [dbo].[PlayerAnswerSet]
ADD CONSTRAINT [FK_TaskAssignmentPlayerAnswer]
    FOREIGN KEY ([TaskAssignmentId])
    REFERENCES [dbo].[TaskAssignmentSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TaskAssignmentPlayerAnswer'
CREATE INDEX [IX_FK_TaskAssignmentPlayerAnswer]
ON [dbo].[PlayerAnswerSet]
    ([TaskAssignmentId]);
GO

-- Creating foreign key on [TaskAssignmentId] in table 'TaskPhaseStatusSet'
ALTER TABLE [dbo].[TaskPhaseStatusSet]
ADD CONSTRAINT [FK_TaskAssignmentTaskPhaseStatus]
    FOREIGN KEY ([TaskAssignmentId])
    REFERENCES [dbo].[TaskAssignmentSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TaskAssignmentTaskPhaseStatus'
CREATE INDEX [IX_FK_TaskAssignmentTaskPhaseStatus]
ON [dbo].[TaskPhaseStatusSet]
    ([TaskAssignmentId]);
GO

-- Creating foreign key on [TaskAssignmentId] in table 'DialogActivationSet'
ALTER TABLE [dbo].[DialogActivationSet]
ADD CONSTRAINT [FK_TaskAssignmentDialogActivation]
    FOREIGN KEY ([TaskAssignmentId])
    REFERENCES [dbo].[TaskAssignmentSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TaskAssignmentDialogActivation'
CREATE INDEX [IX_FK_TaskAssignmentDialogActivation]
ON [dbo].[DialogActivationSet]
    ([TaskAssignmentId]);
GO

-- Creating foreign key on [PlayerAnswerId] in table 'SingleChoicePlayerAnswerSet'
ALTER TABLE [dbo].[SingleChoicePlayerAnswerSet]
ADD CONSTRAINT [FK_PlayerAnswerSingleChoicePlayerAnswer]
    FOREIGN KEY ([PlayerAnswerId])
    REFERENCES [dbo].[PlayerAnswerSet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PlayerAnswerSingleChoicePlayerAnswer'
CREATE INDEX [IX_FK_PlayerAnswerSingleChoicePlayerAnswer]
ON [dbo].[SingleChoicePlayerAnswerSet]
    ([PlayerAnswerId]);
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------